import pygame
import random
import math

from OpenGL.GL import *
from OpenGL.GLU import *

class Vertex:
  def __init__(self):
    self.x,self.y,self.z=0,0,0
    self.u,self.v=0,0
class Triangle:
  def __init__(self):
    self.vertices = [] #only 3 please
class Sector:
  def __init__(self):
    self.triangles = []
def loadworld(filename="Data/World.txt"):
  f = open(filename)
  lines = f.readlines()
  f.close()
  sectors = []
  sector = None
  tri = Triangle()
  for l in lines:
    l = l[:-1]
    if l.startswith("/"): continue
    if not l.strip(): continue
    if "NUMPOLLIES" in l: 
      if sector: sectors.append(sector)
      sector = Sector()
      continue
    vertvals = l.split(" ")
    v = Vertex()
    vertvals[:6]
    v.x,v.y,v.z,v.u,v.v = [float(x) for x in vertvals if x.strip()]
    tri.vertices.append(v)
    if len(tri.vertices)==3:
      sector.triangles.append(tri)
      tri = Triangle()
  sectors.append(sector)
  return sectors

class Screen:
  def __init__(self):
    self.wi = 640
    self.hi = 480
    self.fullscreen = 0
    self.caption = "Nehe lesson 10 - b+w textures, moving bitmap, alpha masks"
    self.glinited = False
    self.texloaded = False
    self.tnames = []
    self.textures = []
    
    self.lighting = False
    self.ambientlight = (.5,.5,.5,1)  #halfbright
    self.diffuselight = (1,1,1,1)  #fullbright
    self.lightpos = (0,0,2,1)   #a little in front of screen
    
    #instance variables to be replaced with objects
    self.yrot = 0
    self.rotateupdown = 0
    self.xpos = 0
    self.zpos = 0
    self.heading = 0
    self.walkbias = 0
    self.walkbiasangle = 0
    
    self.sectors = None
    
    self.filter = 0 #which texture to use
  def initGL(self):
    if not self.texloaded: self.loadGLTextures()
    if not self.sectors: self.sectors = loadworld()
    glEnable(GL_TEXTURE_2D)
    glShadeModel(GL_SMOOTH)
    glClearColor(0,0,0,0)
    glClearDepth(1.)
    glEnable(GL_DEPTH_TEST)
    glDepthFunc(GL_LEQUAL)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST)
    glLightfv(GL_LIGHT1,GL_AMBIENT,self.ambientlight)
    glLightfv(GL_LIGHT1,GL_DIFFUSE,self.diffuselight)
    glLightfv(GL_LIGHT1,GL_POSITION,self.lightpos)
    glEnable(GL_LIGHT1)
    #blending color
    #glEnable(GL_BLEND)
    #glBlendFunc(GL_SRC_ALPHA,GL_ONE)
    #self.glinited = True
  def loadGLTextures(self):
    self.textures.append(pygame.image.load("Data/Mud.bmp"))
    idat = pygame.image.tostring(self.textures[0],"RGB",True)
    self.tnames = glGenTextures(1)
    if not hasattr(self.tnames,"__len__"):
      self.tnames = (self.tnames,)
    #linear filter
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
    glTexImage2D(GL_TEXTURE_2D,0,3,self.textures[0].get_width(),self.textures[0].get_height(),0,GL_RGB,GL_UNSIGNED_BYTE,idat)
    #self.texloaded = True
    self.textures = []
  def resize(self):
    wi,hi,fullscreen = self.wi,self.hi,self.fullscreen
    self.screen = pygame.display.set_mode([wi,hi],pygame.OPENGL|pygame.DOUBLEBUF|pygame.FULLSCREEN*fullscreen|pygame.RESIZABLE)
    pygame.display.set_caption(self.caption)
    if hi==0: hi = 1
    glViewport(0,0,wi,hi)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluPerspective(45.,float(wi)/float(hi),.1,100.)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    if not self.glinited: self.initGL()
  def draw(self):
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    glLoadIdentity()
    glRotatef(self.rotateupdown,1,0,0)
    glRotatef(360-self.yrot,0,1,0)
    glTranslatef(-self.xpos,-self.walkbias-.25,-self.zpos)
    for sec in self.sectors:
      for tri in sec.triangles:
        glBegin(GL_TRIANGLES)
        glNormal3f(0,0,1)
        for v in tri.vertices:
          glTexCoord2f(v.u,v.v);glVertex3f(v.x,v.y,v.z)
        glEnd()

screen = Screen()
screen.resize()

piover180 = math.pi/180.0
running = 1
c = pygame.time.Clock()
while running:
  c.tick(60)
  screen.draw()
  pygame.display.flip()
  for e in pygame.event.get():
    if e.type==pygame.VIDEORESIZE:
      screen.wi,screen.hi = e.w,e.h
      screen.resize()
    if e.type==pygame.KEYDOWN:
      if e.key==pygame.K_ESCAPE:
        running = 0
      if e.key==pygame.K_RETURN:
        screen.wi,screen.hi,screen.fullscreen=40,40,0
        screen.resize()
      if e.key==pygame.K_l:
        screen.lighting = not screen.lighting
        if screen.lighting:
          glEnable(GL_LIGHTING)
        else:
          glDisable(GL_LIGHTING)
      if e.key==pygame.K_f:
        screen.filter += 1
        if screen.filter>2:
          screen.filter=0
  keys = pygame.key.get_pressed()
  if keys[pygame.K_PAGEUP]:
    screen.rotateupdown-=1
  if keys[pygame.K_PAGEDOWN]:
    screen.rotateupdown+=1
  if keys[pygame.K_RIGHT]:
    screen.heading-=1.0
    screen.yrot = screen.heading
  if keys[pygame.K_LEFT]:
    screen.heading+=1.0
    screen.yrot = screen.heading
  if keys[pygame.K_UP]:
    screen.xpos-=float(math.sin(float(screen.heading)*piover180))*.05
    screen.zpos-=float(math.sin(float(screen.heading+90)*piover180))*.05
    screen.walkbiasangle += 10
    screen.walkbias = float(math.sin(screen.walkbiasangle*piover180))/20.
  if keys[pygame.K_DOWN]:
    screen.xpos+=float(math.sin(float(screen.heading)*piover180))*.05
    screen.zpos+=float(math.sin(float(screen.heading+90)*piover180))*.05
    screen.walkbiasangle -= 10
    screen.walkbias = float(math.sin(screen.walkbiasangle*piover180))/20.
